camp_triggers = {
	['Sommervieu Airbase Disabled Text'] = {
		['condition'] = 'Return.TargetAlive("Sommervieu Airbase") < 2',
		['once'] = false,
		['action'] = {
			[1] = 'Action.Text("The infrastructure at Sommervieu Airbase has been destroyed by air strikes. Flying operations at this base have ceased completely and are unlikely to resume. This will ease our efforts to hit other targets in the Kutaisi Country area.")',
		},
		['active'] = true,
	},
	['Saint-Pierre-du-Mont Airbase Disabled Text'] = {
		['condition'] = 'Return.TargetAlive("Saint-Pierre-du-Mont Airbase") < 2',
		['once'] = false,
		['action'] = {
			[1] = 'Action.Text("After the facilities at Saint-Pierre-du-Mont Airbase have been hit by air strikes, air operations at this base came to a complete stop. Intelligence believes that due to the heavy damage inflicted, the base is no longer ably to produce any aviation sorties.")',
		},
		['active'] = true,
	},
	['Sommervieu Airbase Disabled'] = {
		['condition'] = 'Return.TargetAlive("Sommervieu Airbase") < 2',
		['action'] = {
			[1] = 'db_airbases["Sommervieu"].inactive = true',
		},
		['active'] = true,
	},
	['Lessay Airbase Disabled'] = {
		['condition'] = 'Return.TargetAlive("Lessay Airbase") < 2',
		['action'] = {
			[1] = 'db_airbases["Lessay"].inactive = true',
		},
		['active'] = true,
	},
	['Needs Oar Point Airbase Disabled Text'] = {
		['condition'] = 'Return.TargetAlive("Needs Oar Point Airbase") < 2',
		['once'] = false,
		['action'] = {
			[1] = 'Action.Text("The infrastructure at Needs Oar Point Airbase has been destroyed by air strikes. Flying operations at this base have ceased completely and are unlikely to resume. This will ease our efforts to hit other targets in the Kutaisi Country area.")',
		},
		['active'] = true,
	},
	['Landing Force'] = {
		['condition'] = 'Return.Mission() == 1',
		['once'] = true,
		['action'] = 'Action.ShipMission("Landing Force", {{"LF1-1", "LF1-2", "LF1-3", "LF1-4", "LF1-5"}}, 11, 5, nil)',
		['active'] = true,
	},
	['Reinforce Jagdgeschwader 5'] = {
		['condition'] = 'true',
		['action'] = 'Action.AirUnitReinforce("R/Anton", "Jagdgeschwader 5", 2)',
		['active'] = true,
	},
	['352nd Fighter Group Alive 75%'] = {
		['condition'] = 'Return.AirUnitAlive("352nd Fighter Group") + Return.AirUnitReady("R/P51 Fighter Group") < 40',
		['once'] = true,
		['action'] = 'Action.Text("Aircraft strength of the 352nd Fighter Group equiped with Mustangs has fallen below 75%.")',
		['active'] = true,
	},
	['Reinforce No. 19 Squadron RAF'] = {
		['condition'] = 'true',
		['action'] = 'Action.AirUnitReinforce("R/RAF", "No. 19 Squadron RAF", 4)',
		['active'] = true,
	},
	['Red Ground Target Briefing Intel'] = {
		['condition'] = 'true',
		['action'] = 'Action.AddGroundTargetIntel("red")',
		['active'] = true,
	},
	['Campaign End Victory 1'] = {
		['condition'] = 'GroundTarget["blue"].percent < 30',
		['once'] = false,
		['action'] = {
			[1] = 'Action.CampaignEnd("win")',
			[2] = 'Action.Text("The ground forces of The Third Reich have a decimated.  Remaining German troops are on the retreat.  We are on our way to Berlin!")',
			[4] = 'NoMoreNewspaper = true',
			[3] = 'Action.AddImage("Newspaper_VEDay.jpg", "all")',
		},
		['active'] = true,
	},
	['Campaign first destructions'] = {
		['condition'] = 'GroundTarget["blue"].percent < 100',
		['once'] = true,
		['action'] = {
			[1] = 'Action.Text("First targets have been destroyed. Keep up the good work")',
		},
		['active'] = false,
	},
	['Saint-Pierre-du-Mont Airbase Disabled'] = {
		['condition'] = 'Return.TargetAlive("Saint-Pierre-du-Mont Airbase") < 2',
		['action'] = {
			[1] = 'db_airbases["Saint-Pierre-du-Mont"].inactive = true',
		},
		['active'] = true,
	},
	['Cricqueville-en-Bessin Airbase Disabled'] = {
		['condition'] = 'Return.TargetAlive("Cricqueville-en-Bessin Airbase") < 2',
		['action'] = {
			[1] = 'db_airbases["Cricqueville-en-Bessin"].inactive = true',
		},
		['active'] = true,
	},
	['Reinforce 353rd Fighter Group'] = {
		['condition'] = 'true',
		['action'] = 'Action.AirUnitReinforce("R/P51 Fighter Group", "353rd Fighter Group", 2)',
		['active'] = true,
	},
	['Longues-sur-mer Airbase Disabled'] = {
		['condition'] = 'Return.TargetAlive("Longues-sur-mer Airbase") < 2',
		['action'] = {
			[1] = 'db_airbases["Lonues-sur-mer"].inactive = true',
		},
		['active'] = true,
	},
	['Campaign 20 percents destructions'] = {
		['condition'] = 'GroundTarget["blue"].percent < 80',
		['once'] = true,
		['action'] = {
			[1] = 'Action.Text("Enemy targets have sustained fair damages. Keep up the good work")',
		},
		['active'] = true,
	},
	['Chailey Airbase Disabled Text'] = {
		['condition'] = 'Return.TargetAlive("Chailey Airbase") < 2',
		['once'] = true,
		['action'] = {
			[1] = 'Action.Text("Recent air strikes have destroyed enemy ground elements running operations at Chailey Airbase. Without their ground support, any remaining aircraft at the airstrip will no longer be able to launch on sorties.")',
		},
		['active'] = true,
	},
	['Reinforce 363 Fighter Group'] = {
		['condition'] = 'true',
		['action'] = 'Action.AirUnitReinforce("R/P-47-30", "363 Fighter Group", 2)',
		['active'] = true,
	},
	['352nd Fighter Group Alive 25%'] = {
		['condition'] = 'Return.AirUnitAlive("352nd Fighter Group") + Return.AirUnitReady("R/P51 Fighter Group") < 13',
		['once'] = true,
		['action'] = 'Action.Text("Aircraft strength of the 352nd Fighter Group equiped with Mustangs has fallen below 25%. The number of available airframes is critically low. The squadron is short of destruction.")',
		['active'] = true,
	},
	['Maupertus Airbase Disabled Text'] = {
		['condition'] = 'Return.TargetAlive("Maupertus Airbase") < 2',
		['once'] = true,
		['action'] = {
			[1] = 'Action.Text("Recent air strikes have destroyed enemy ground elements running operations at Maupertus Airbase. Without their ground support, any remaining aircraft at the airstrip will no longer be able to launch on sorties.")',
		},
		['active'] = true,
	},
	['Reinforce V./Kampfgeschwader 40'] = {
		['condition'] = 'true',
		['action'] = 'Action.AirUnitReinforce("R/Junkers", "V./Kampfgeschwader 40", 2)',
		['active'] = true,
	},
	['Ford AF Airbase Disabled Text'] = {
		['condition'] = 'Return.TargetAlive("Ford_AF Airbase") < 2',
		['once'] = true,
		['action'] = {
			[1] = 'Action.Text("Recent air strikes have destroyed enemy ground elements running operations at Ford AF Airbase. Without their ground support, any remaining aircraft at the airstrip will no longer be able to launch on sorties.")',
		},
		['active'] = true,
	},
	['Conches Airbase Disabled Text'] = {
		['condition'] = 'Return.TargetAlive("Conches Airbase") < 2',
		['once'] = true,
		['action'] = {
			[1] = 'Action.Text("Recent air strikes have destroyed enemy ground elements running operations at Conches Airbase. Without their ground support, any remaining aircraft at the airstrip will no longer be able to launch on sorties.")',
		},
		['active'] = true,
	},
	['Campaign End Draw'] = {
		['condition'] = 'MissionInstance == 40',
		['once'] = true,
		['action'] = {
			[1] = 'Action.CampaignEnd("draw")',
			[2] = 'Action.Text("The air campaign has seen a sustained period of inactivity. Seemingly unable to complete the destruction of the Russian Air Force and infrastructure, US Central Command has called off all squadrons from offensive operations. We hope negociations with Russians will convince them to withdraw from Georgia")',
			[3] = 'NoMoreNewspaper = true',
		},
		['active'] = true,
	},
	['Sainte-Laurent-sur-mer Airbase Disabled'] = {
		['condition'] = 'Return.TargetAlive("Sainte-Laurent-sur-mer Airbase") < 2',
		['action'] = {
			[1] = 'db_airbases["Sainte-Laurent-sur-mer"].inactive = true',
		},
		['active'] = true,
	},
	['Essay Airbase Disabled'] = {
		['condition'] = 'Return.TargetAlive("Essay Airbase") < 2',
		['action'] = {
			[1] = 'db_airbases["Essay"].inactive = true',
		},
		['active'] = true,
	},
	['Evreux Airbase Disabled'] = {
		['condition'] = 'Return.TargetAlive("Evreux Airbase") < 2',
		['action'] = {
			[1] = 'db_airbases["Evreux"].inactive = true',
		},
		['active'] = true,
	},
	['Naval Supply 1'] = {
		['condition'] = 'Return.Mission() == 1',
		['once'] = true,
		['action'] = 'Action.ShipMission("Naval Supply 1", {{"Sierra 1-1", "Sierra 1-2", "Sierra 1-3", "Sierra 1-4"}}, 8, 5, nil)',
		['active'] = true,
	},
	['Longues-sur-mer Airbase Disabled Text'] = {
		['condition'] = 'Return.TargetAlive("Longues-sur-mer Airbase") < 2',
		['once'] = false,
		['action'] = {
			[1] = 'Action.Text("After the facilities at Lonues-sur-mer Airbase have been hit by air strikes, air operations at this base came to a complete stop. Intelligence believes that due to the heavy damage inflicted, the base is no longer ably to produce any aviation sorties.")',
		},
		['active'] = true,
	},
	['Campaign End Victory 2'] = {
		['condition'] = 'Return.AirUnitReady("Jagdgeschwader 26") + Return.AirUnitReady("Jagdgeschwader 28") + Return.AirUnitReady("Jagdgeschwader 4") + Return.AirUnitReady("Jagdgeschwader 5") + Return.AirUnitReady("Jagdgeschwader 334") + Return.AirUnitReady("Jagdgeschwader 335") + Return.AirUnitReady("V./Kampfgeschwader 40") + Return.AirUnitReady("V./Kampfgeschwader 41") + Return.AirUnitReady("R/BF109") + Return.AirUnitReady("R/Anton") + Return.AirUnitReady("R/DORA") + Return.AirUnitReady("R/Junkers") < 1',
		['once'] = true,
		['action'] = {
			[1] = 'Action.CampaignEnd("win")',
			[2] = 'Action.Text("You have defeated the Luftwaffe.  Ground forces can now advance without any threat from the skies.  You have gained air superiority.")',
			[4] = 'NoMoreNewspaper = true',
			[3] = 'Action.AddImage("Newspaper_VEDay.jpg", "all")',
		},
		['active'] = true,
	},
	['Reinforce 447th Bomb Group'] = {
		['condition'] = 'true',
		['action'] = 'Action.AirUnitReinforce("R/Bomb Group", "447th Bomb Group", 4)',
		['active'] = true,
	},
	['Campaign End Loss'] = {
		['condition'] = 'Return.AirUnitAlive("352nd Fighter Group") + Return.AirUnitReady("R/P51 Fighter Group") < 4',
		['once'] = false,
		['action'] = {
			[1] = 'Action.CampaignEnd("loss")',
			[2] = 'Action.Text("You have taken too many loses.  We would no longer be able to achieve air superiority")',
			[4] = 'NoMoreNewspaper = true',
			[3] = 'Action.AddImage("Newspaper_FranceCaptured.jpg", "all")',
		},
		['active'] = true,
	},
	['Evreux Airbase Disabled Text'] = {
		['condition'] = 'Return.TargetAlive("Evreux Airbase") < 2',
		['once'] = true,
		['action'] = {
			[1] = 'Action.Text("Recent air strikes have destroyed enemy ground elements running operations at Evreux Airbase. Without their ground support, any remaining aircraft at the airstrip will no longer be able to launch on sorties.")',
		},
		['active'] = true,
	},
	['Reinforce Jagdgeschwader 335'] = {
		['condition'] = 'true',
		['action'] = 'Action.AirUnitReinforce("R/DORA", "Jagdgeschwader 335", 2)',
		['active'] = true,
	},
	['Campaign End Loss 2'] = {
		['condition'] = 'Return.TargetAlive("Naval Supply 1") == 0 and Return.TargetAlive("Naval Supply 2") == 0',
		['once'] = false,
		['action'] = {
			[1] = 'Action.CampaignEnd("loss")',
			[2] = 'Action.Text("We have lost our supply ships.  It is only a matter of time now before we run out of fuel and ammo.")',
			[4] = 'NoMoreNewspaper = true',
			[3] = 'Action.AddImage("Newspaper_FranceCaptured.jpg", "all")',
		},
		['active'] = true,
	},
	['Reinforce 362 Fighter Group'] = {
		['condition'] = 'true',
		['action'] = 'Action.AirUnitReinforce("R/P-47-30", "362 Fighter Group", 4)',
		['active'] = true,
	},
	['Repair'] = {
		['condition'] = 'true',
		['action'] = 'Action.AirUnitRepair()',
		['active'] = true,
	},
	['Reinforce 352nd Fighter Group'] = {
		['condition'] = 'true',
		['action'] = 'Action.AirUnitReinforce("R/P51 Fighter Group", "352nd Fighter Group", 4)',
		['active'] = true,
	},
	['Reinforce No. 24 Squadron RAF'] = {
		['condition'] = 'true',
		['action'] = 'Action.AirUnitReinforce("R/RAF", "No. 24 Squadron RAF", 2)',
		['active'] = true,
	},
	['Campaign 40 percents destructions'] = {
		['condition'] = 'GroundTarget["blue"].percent < 60',
		['once'] = true,
		['action'] = {
			[1] = 'Action.Text("Enemy targets have sustained great damages. Strike missions are really efficient and we will win this war soon")',
		},
		['active'] = true,
	},
	['Campaign 50 percents destructions'] = {
		['condition'] = 'GroundTarget["blue"].percent < 50',
		['once'] = true,
		['action'] = {
			[1] = 'Action.Text("More than half of our targets are neutralized. Intelligence think that the enemy will ask for a cease fire soon")',
		},
		['active'] = true,
	},
	['Chailey Airbase Disabled'] = {
		['condition'] = 'Return.TargetAlive("Chailey Airbase") < 2',
		['action'] = {
			[1] = 'db_airbases["Chailey"].inactive = true',
		},
		['active'] = true,
	},
	['Naval Supply 2'] = {
		['condition'] = 'Return.Mission() == 1',
		['once'] = true,
		['action'] = 'Action.ShipMission("Naval Supply 2", {{"Sierra 2-1", "Sierra 2-2", "Sierra 2-3", "Sierra 2-4"}}, 8, 5, nil)',
		['active'] = true,
	},
	['Sainte-Laurent-sur-mer Airbase Disabled Text'] = {
		['condition'] = 'Return.TargetAlive("Sainte-Laurent-sur-mer Airbase") < 2',
		['once'] = false,
		['action'] = {
			[1] = 'Action.Text("After the facilities at Sainte-Laurent-sur-mer Airbase have been hit by air strikes, air operations at this base came to a complete stop. Intelligence believes that due to the heavy damage inflicted, the base is no longer ably to produce any aviation sorties.")',
		},
		['active'] = true,
	},
	['Hauterive Airbase Disabled'] = {
		['condition'] = 'Return.TargetAlive("Hauterive Airbase") < 2',
		['action'] = {
			[1] = 'db_airbases["Hauterive"].inactive = true',
		},
		['active'] = true,
	},
	['Reinforce 360th Fighter Group'] = {
		['condition'] = 'true',
		['action'] = 'Action.AirUnitReinforce("R/P51 Escort Group", "360th Fighter Group", 2)',
		['active'] = true,
	},
	['Reinforce Jagdgeschwader 28'] = {
		['condition'] = 'true',
		['action'] = 'Action.AirUnitReinforce("R/BF109", "Jagdgeschwader 28", 4)',
		['active'] = true,
	},
	['Reinforce Jagdgeschwader 26'] = {
		['condition'] = 'true',
		['action'] = 'Action.AirUnitReinforce("R/BF109", "Jagdgeschwader 26", 4)',
		['active'] = true,
	},
	['Essay Airbase Disabled Text'] = {
		['condition'] = 'Return.TargetAlive("Essay Airbase") < 2',
		['once'] = true,
		['action'] = {
			[1] = 'Action.Text("Recent air strikes have destroyed enemy ground elements running operations at Essay Airbase. Without their ground support, any remaining aircraft at the airstrip will no longer be able to launch on sorties.")',
		},
		['active'] = true,
	},
	['Cricqueville-en-Bessin Airbase Disabled Text'] = {
		['condition'] = 'Return.TargetAlive("Cricqueville-en-Bessin Airbase") < 2',
		['once'] = false,
		['action'] = {
			[1] = 'Action.Text("After the facilities at Cricqueville-en-Bessin Airbase have been hit by air strikes, air operations at this base came to a complete stop. Intelligence believes that due to the heavy damage inflicted, the base is no longer ably to produce any aviation sorties.")',
		},
		['active'] = true,
	},
	['Hauterive Airbase Disabled Text'] = {
		['condition'] = 'Return.TargetAlive("Hauterive Airbase") < 2',
		['once'] = true,
		['action'] = {
			[1] = 'Action.Text("Recent air strikes have destroyed enemy ground elements running operations at Hauterive Airbase. Without their ground support, any remaining aircraft at the airstrip will no longer be able to launch on sorties.")',
		},
		['active'] = true,
	},
	['Ford AF Airbase Disabled'] = {
		['condition'] = 'Return.TargetAlive("Ford_AF Airbase") < 2',
		['action'] = {
			[1] = 'db_airbases["Ford AF"].inactive = true',
		},
		['active'] = true,
	},
	['Reinforce 640th Bombardment Squadron'] = {
		['condition'] = 'true',
		['action'] = 'Action.AirUnitReinforce("R/640th Bombardment Squadron", "640th Bombardment Squadron", 4)',
		['active'] = true,
	},
	['Maupertus Airbase Disabled'] = {
		['condition'] = 'Return.TargetAlive("Maupertus Airbase") < 2',
		['action'] = {
			[1] = 'db_airbases["Maupertus"].inactive = true',
		},
		['active'] = true,
	},
	['GroundUnitRepair'] = {
		['condition'] = 'true',
		['action'] = 'Action.GroundUnitRepair()',
		['active'] = true,
	},
	['Conches Airbase Disabled'] = {
		['condition'] = 'Return.TargetAlive("Conches Airbase") < 2',
		['action'] = {
			[1] = 'db_airbases["Conches"].inactive = true',
		},
		['active'] = true,
	},
	['Reinforce No. 20 Squadron RAF'] = {
		['condition'] = 'true',
		['action'] = 'Action.AirUnitReinforce("R/RAF", "No. 20 Squadron RAF", 4)',
		['active'] = true,
	},
	['Reinforce V./Kampfgeschwader 41'] = {
		['condition'] = 'true',
		['action'] = 'Action.AirUnitReinforce("R/Junkers", "V./Kampfgeschwader 41", 2)',
		['active'] = true,
	},
	['Campaign Briefing'] = {
		['condition'] = 'true',
		['once'] = true,
		['action'] = {
			[2] = 'Action.Text("Our troops have established a beach head and secured airfields for the Air Force to operate from.  The fleet off the coast will provide us with supplies.  It is vital that the we protect those ships and landing crafts.")',
			[3] = 'Action.Text("We need to liberate St. Lo and Caen to support the ground force movement south.  While the re-capture of Carentan is also of importance.  This would cut-off supplies from the Port of Cherbourg going south to German forces.")',
			[1] = 'Action.Text("Operation Overlord")',
			[4] = 'Action.Text("Intel is limited and at times inaccurate.  Be ready for nasty surprises.  The only recon photos we have are of fixed isntallations and some Divisions who have been stationed near towns for some time.  Go find the enemey and destroy them.")',
			[5] = 'Action.AddImage("operation-overlord-map.png", "all")',
		},
		['active'] = false,
	},
	['Lessay Airbase Disabled Text'] = {
		['condition'] = 'Return.TargetAlive("Lessay Airbase") < 2',
		['once'] = true,
		['action'] = {
			[1] = 'Action.Text("Recent air strikes have destroyed enemy ground elements running operations at Lessay Airbase. Without their ground support, any remaining aircraft at the airstrip will no longer be able to launch on sorties.")',
		},
		['active'] = true,
	},
	['Blue Ground Target Briefing Intel'] = {
		['condition'] = 'true',
		['action'] = 'Action.AddGroundTargetIntel("blue")',
		['active'] = true,
	},
	['Reinforce Jagdgeschwader 334'] = {
		['condition'] = 'true',
		['action'] = 'Action.AirUnitReinforce("R/DORA", "Jagdgeschwader 334", 4)',
		['active'] = true,
	},
	['Reinforce Jagdgeschwader 4'] = {
		['condition'] = 'true',
		['action'] = 'Action.AirUnitReinforce("R/Anton", "Jagdgeschwader 4", 4)',
		['active'] = true,
	},
	['352nd Fighter Group Alive 50%'] = {
		['condition'] = 'Return.AirUnitAlive("352nd Fighter Group") + Return.AirUnitReady("R/P51 Fighter Group") < 27',
		['once'] = true,
		['action'] = 'Action.Text("Aircraft strength of the 352nd Fighter Group equiped with Mustangs has fallen below 50%. If losses continue at the present rate, the combat capability of the squadron is in jeopardy.")',
		['active'] = true,
	},
	['Needs Oar Point Airbase Disabled'] = {
		['condition'] = 'Return.TargetAlive("Needs Oar Point Airbase") < 2',
		['action'] = {
			[1] = 'db_airbases["Needs Oar Point"].inactive = true',
		},
		['active'] = true,
	},
}
